(function(cash) {
    
    function fixTitle($ele) {
        if ($ele.attr('title') || typeof($ele.attr('original-title')) != 'string') {
            $ele.attr('original-title', $ele.attr('title') || '').removeAttr('title');
        }
    }
    
    function Tipsy(element, options) {
        this.$element = $(element);
        this.options = options;
        this.enabled = true;
        fixTitle(this.$element);
    }
    
    Tipsy.prototype = {
        show: function() {
            var title = this.getTitle();
            if (title && this.enabled) {
                var $tip = this.tip();
                
                $tip.find('.tipsy-inner')[this.options.html ? 'html' : 'text'](title);
                $tip[0].className = 'tipsy'; // reset classname in case of dynamic gravity
                $tip.remove().css({top: 0, left: 0, visibility: 'hidden', display: 'block'}).appendTo(document.body);
                
                var pos = $.extend({}, this.$element.offset(), {
                    width: this.$element[0].offsetWidth,
                    height: this.$element[0].offsetHeight
                });
                
                var actualWidth = $tip[0].offsetWidth, actualHeight = $tip[0].offsetHeight;
                var gravity = (typeof this.options.gravity == 'function')
                                ? this.options.gravity.call(this.$element[0])
                                : this.options.gravity;
                
                var tp;
                switch (gravity.charAt(0)) {
                    case 'n':
                        tp = {top: pos.top + pos.height + this.options.offset, left: pos.left + pos.width / 2 - actualWidth / 2};
                        break;
                    case 's':
                        tp = {top: pos.top - actualHeight - this.options.offset, left: pos.left + pos.width / 2 - actualWidth / 2};
                        break;
                    case 'e':
                        tp = {top: pos.top + pos.height / 2 - actualHeight / 2, left: pos.left - actualWidth - this.options.offset};
                        break;
                    case 'w':
                        tp = {top: pos.top + pos.height / 2 - actualHeight / 2, left: pos.left + pos.width + this.options.offset};
                        break;
                }
                
                if (gravity.length == 2) {
                    if (gravity.charAt(1) == 'w') {
                        tp.left = pos.left + pos.width / 2 - 15;
                    } else {
                        tp.left = pos.left + pos.width / 2 - actualWidth + 15;
                    }
                }
                
                $tip.css(tp).addClass('tipsy-' + gravity);
                
                if (this.options.fade) {
                    $tip.stop().css({opacity: 0, display: 'block', visibility: 'visible'}).animate({opacity: this.options.opacity});
                } else {
                    $tip.css({visibility: 'visible', opacity: this.options.opacity});
                }
            }
        },
        
        hide: function() {
            if (this.options.fade) {
                this.tip().stop().fadeOut(function() {$(this).remove();});
            } else {
                this.tip().remove();
            }
        },
        
        getTitle: function() {
            var title, $e = this.$element, o = this.options;
            fixTitle($e);
            var title, o = this.options;
            if (typeof o.title == 'string') {
                title = $e.attr(o.title == 'title' ? 'original-title' : o.title);
            } else if (typeof o.title == 'function') {
                title = o.title.call($e[0]);
            }
            title = ('' + title).replace(/(^\s*|\s*$)/, "");
            return title || o.fallback;
        },
        
        tip: function() {
            if (!this.$tip) {
                this.$tip = $('<div class="tipsy"></div>').html('<div class="tipsy-arrow"></div><div class="tipsy-inner"/></div>');
            }
            return this.$tip;
        },
        
        validate: function() {
            if (!this.$element[0].parentNode) {
                this.hide();
                this.$element = null;
                this.options = null;
            }
        },
        
        enable: function() {this.enabled = true;},
        disable: function() {this.enabled = false;},
        toggleEnabled: function() {this.enabled = !this.enabled;}
    };
    
    $.fn.tipsy = function(options) {
        
        if (options === true) {
            return this.data('tipsy');
        } else if (typeof options == 'string') {
            return this.data('tipsy')[options]();
        }
        
        options = $.extend({}, $.fn.tipsy.defaults, options);
        
        function get(ele) {
            var tipsy = $.data(ele, 'tipsy');
            if (!tipsy) {
                tipsy = new Tipsy(ele, $.fn.tipsy.elementOptions(ele, options));
                $.data(ele, 'tipsy', tipsy);
            }
            return tipsy;
        }
        
        function enter() {
            var tipsy = get(this);
            tipsy.hoverState = 'in';
            if (options.delayIn == 0) {
                tipsy.show();
            } else {
                setTimeout(function() {if (tipsy.hoverState == 'in') tipsy.show();}, options.delayIn);
            }
        };
        
        function leave() {
            var tipsy = get(this);
            tipsy.hoverState = 'out';
            if (options.delayOut == 0) {
                tipsy.hide();
            } else {
                setTimeout(function() {if (tipsy.hoverState == 'out') tipsy.hide();}, options.delayOut);
            }
        };
        
        if (!options.live) this.each(function() {get(this);});
        
        if (options.trigger != 'manual') {
            var binder   = options.live ? 'live' : 'bind',
                eventIn  = options.trigger == 'hover' ? 'mouseenter' : 'focus',
                eventOut = options.trigger == 'hover' ? 'mouseleave' : 'blur';
            this[binder](eventIn, enter)[binder](eventOut, leave);
        }
        
        return this;
        
    };
    
    $.fn.tipsy.defaults = {
        delayIn: 0,
        delayOut: 0,
        fade: false,
        fallback: '',
        gravity: 'n',
        html: false,
        live: false,
        offset: 0,
        opacity: 1,
        title: 'title',
        trigger: 'hover'
    };
    
    $.fn.tipsy.elementOptions = function(ele, options) {
        return $.metadata ? $.extend({}, options, $(ele).metadata()) : options;
    };
    
    $.fn.tipsy.autoNS = function() {
        return $(this).offset().top > ($(document).scrollTop() + $(window).height() / 2) ? 's' : 'n';
    };
    
    $.fn.tipsy.autoWE = function() {
        return $(this).offset().left > ($(document).scrollLeft() + $(window).width() / 2) ? 'e' : 'w';
    };
    
})(jQuery);

jQuery(document).ready(function($){
        $('.go').each(function() {
                var url = $(this).attr('inf');
                $(this).click(
                        function() {
                                $(this).attr('href', url);
                        }
                );        
        });
        $("select#actors-dropdown").change(function(){
                window.location.href = $(this).val();
        });
        $("select#director-dropdown").change(function(){
                window.location.href = $(this).val();
        });
        $("select#country-dropdown").change(function(){
                window.location.href = $(this).val();
        });
        $("select#year-dropdown").change(function(){
        window.location.href = $(this).val();
        });
		
        $('.noLogin').tipsy({
          fade: true,
          gravity: "s"  
        });
        $('#author').tipsy({
          fade: true,
          gravity: 'w',
          trigger: 'manual'
         });
         $('#comment').tipsy({
          fade: true,
          gravity: 'n',
          trigger: 'manual'
         });
        $('#comment, #author').focus(function(){
         $(this).tipsy("hide");
        });
});

function preventSelection(element){
  var preventSelection = false;

  function addHandler(element, event, handler){
    if (element.attachEvent) 
      element.attachEvent('on' + event, handler);
    else 
      if (element.addEventListener) 
        element.addEventListener(event, handler, false);
  }
  function removeSelection(){
    if (window.getSelection) { window.getSelection().removeAllRanges(); }
    else if (document.selection && document.selection.clear)
      document.selection.clear();
  }
  function killCtrlA(event){
    var event = event || window.event;
    var sender = event.target || event.srcElement;

    if (sender.tagName.match(/INPUT|TEXTAREA/i))
      return;

    var key = event.keyCode || event.which;
    if (event.ctrlKey && key == 'A'.charCodeAt(0)) 
    {
      removeSelection();

      if (event.preventDefault) 
        event.preventDefault();
      else
        event.returnValue = false;
    }
  }

  addHandler(element, 'mousemove', function(){
    if(preventSelection)
      removeSelection();
  });
  addHandler(element, 'mousedown', function(event){
    var event = event || window.event;
    var sender = event.target || event.srcElement;
    preventSelection = !sender.tagName.match(/INPUT|TEXTAREA/i);
  });


  addHandler(element, 'mouseup', function(){
    if (preventSelection)
      removeSelection();
    preventSelection = false;
  });

  addHandler(element, 'keydown', killCtrlA);
  addHandler(element, 'keyup', killCtrlA);
}
preventSelection(document);

function getElem(id) { return document.getElementById(id); }

Function.prototype.NEW = function() {
	var c = new this();
	c.__init__.apply(c, arguments);
	return c;
}

Function.prototype.bind = function(obj) {
	return callback(obj, this);
}

function callback(obj, f) {
	return function() {
		return f.apply(obj, arguments)
	}
}

SelectFilm = function() {};

SelectFilm.prototype.__init__ = function(){
	this._series = window.MP_SETTINGS.SERIES_LIST;
	
	this._fillSelectSeries();
	this._selectSeries();
}

SelectFilm.prototype._fillSelectSeries = function(){
	var select = getElem('series'), i = 0,j = 0,
		series = this._series, optgroup, option;
	
	select.onchange = this._selectSeries.bind(this);
	
	for(;i < series.length; i++){
		optgroup = document.createElement('optgroup');
		optgroup.label = '����� '+(i+1);
		select.appendChild(optgroup);
		if(!series[i]) continue;
		for(j = 0;j < series[i].length; j++){
			if(!series[i][j]) continue;
			option = document.createElement('option');
			option.innerHTML = '����� ' + (j+1);
			option.value = series[i][j];
			optgroup.appendChild(option);
		}
	}
	select.options[0].selected = true;
}

SelectFilm.prototype._selectSeries = function(){
	getElem('ifr').src = getElem('series').value;
}

    function grin(tag) {
    	if (typeof tinyMCE != 'undefined') {
    		grin_tinymcecomments(tag);
    	} else {
    		grin_plain(tag);
    	}
    }
    function grin_tinymcecomments(tag) {
    	tinyMCE.execCommand('mceInsertContent', false, ' ' + tag + ' ');
    }
    
    function grin_plain(tag) {
    	var myField;
    	var myCommentTextarea = "comment";
    	tag = ' ' + tag + ' ';
        if (document.getElementById(myCommentTextarea) && document.getElementById(myCommentTextarea).type == 'textarea') {
    		myField = document.getElementById(myCommentTextarea);
    	} else {
    		return false;
    	}
    	if (document.selection) {
    		myField.focus();
    		sel = document.selection.createRange();
    		sel.text = tag;
    		myField.focus();
    	}
    	else if (myField.selectionStart || myField.selectionStart == '0') {
    		var startPos = myField.selectionStart;
    		var endPos = myField.selectionEnd;
    		var cursorPos = endPos;
    		myField.value = myField.value.substring(0, startPos)
    					  + tag
    					  + myField.value.substring(endPos, myField.value.length);
    		cursorPos += tag.length;
    		myField.focus();
    		myField.selectionStart = cursorPos;
    		myField.selectionEnd = cursorPos;
    	}
    	else {
    		myField.value += tag;
    		myField.focus();
    	}
    }
    
    function moreSmilies() {
    	document.getElementById('wp-smiley-more').style.display = 'inline';
    	document.getElementById('wp-smiley-toggle').innerHTML = '<a href="javascript:lessSmilies()">&laquo;&nbsp;less</a></span>';
    }
    
    function lessSmilies() {
    	document.getElementById('wp-smiley-more').style.display = 'none';
    	document.getElementById('wp-smiley-toggle').innerHTML = '<a href="javascript:moreSmilies()">more&nbsp;&raquo;</a>';
    }
	
function addToFav(userId,filmId, el){
            var thisEl = jQuery(el);
            var actn = 'add';
            if(thisEl.hasClass('added')){
                actn = 'removed';
            }
            jQuery.ajax({
                url: addToFavParth + "/functions/add_to_favorite.php",
                data: 'userID=' + userId + '&filmID=' + filmId + '&action=' + actn,
                success: function(data){
      var flItem = thisEl.parent('.post');
                    if(data == 'added'){
   showLinkBm(thisEl, 'add');
                        //thisEl.addClass('added');
                    }
                    if(data == 'removed'){
                        //thisEl.removeClass('added');
   if(thisEl.hasClass('favListItem')){    
    flItem.animate({opacity: 0},300,function(){jQuery(this).hide()});
    }
    showLinkBm(thisEl, 'remove');
   }
   if(data == 'empty'){
                         //thisEl.removeClass('added');
    flItem.animate({opacity: 0},300,function(){jQuery(this).hide().after('<div id="searchno">��� ������ ���������� ����</div>')});
    showLinkBm(thisEl, 'remove');
    }
   }
  });
 }
function showLinkBm(el, arg){
  var duration = 300;
  var linkText = jQuery('.' + arg, el);
  var hiddenLink = jQuery('span:hidden', el);
  if(linkText.is(':visible')) {
   linkText.fadeOut(duration, function(){
    if(arg == 'add'){
     el.addClass('added'); 
    }
    else{
     el.removeClass('added'); 
    }
    hiddenLink.fadeIn(duration)
   })
  }
 }

function validate_form ( )
{
 valid = true;

        if ( document.contact_form.author.value == "" )
        {

  $("#author").tipsy("show");
                valid = false;
        }
  if ( document.contact_form.comment.value == "" )
        {

    $("#comment").tipsy("show");
                valid = false;
        }

        return valid;
}

function validate_form_logged ( )
{
 valid = true;
       
  if ( document.contact_form.comment.value == "" )
        {

      $("#comment").tipsy("show");
                valid = false;
        }

        return valid;
}